/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.pe.ceutils.ConnectionPoint;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.pa.peconnection.IPEConnection;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.VWConnectionPointDialog;
import java.io.File;

public class PAConnectDialog
extends VWConnectionPointDialog {
    private IPEConnection m_peConn = null;
    private String m_ceURL = null;
    private String m_userName = null;
    private String m_password = null;

    public static PAConnectDialog getInstance(String defaultConnectionPoint, IPEConnection peConn, String ceURL, String userName, String password) throws Exception {
        ConnectionPoint[] cps = peConn.getConnectionPoints(ceURL, userName, password);
        if (cps == null || cps.length == 0) {
            throw new VWException("filenet.vw.apps.taskman.pa.PAConnectDialog.NoConnectionPointsDefined", "No connection points are defined.  At least one connection point must be defined on the Content Engine.");
        }
        return new PAConnectDialog(cps, defaultConnectionPoint, peConn, ceURL, userName, password);
    }

    private PAConnectDialog(ConnectionPoint[] cps, String defaultConnectionPoint, IPEConnection peConn, String ceURL, String userName, String password) throws Exception {
        super(cps, defaultConnectionPoint, VWResource.ConnectToProcessEngine, VWResource.Connect, "taskmanager" + File.separator + "pa_connect_dialog.htm");
        this.m_peConn = peConn;
        this.m_ceURL = ceURL;
        this.m_userName = userName;
        this.m_password = password;
    }

    public void performOKAction() throws Exception {
        try {
            this.m_peConn.connect(this.m_ceURL, this.m_userName, this.m_password, this.getSelectedConnectionPoint().Name);
        }
        catch (Exception e) {
            VWException vwEx = new VWException("filenet.vw.apps.taskman.pa.PAConnectDialogConnectEx", "A Process Engine connection could not be established.");
            vwEx.setCause(e);
            throw vwEx;
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   27 Sep 2006 17:25:58  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }
}

